\name{ugkum}
\alias{ugkum}
\docType{data}
\title{
Censo Forestal del Plan Operativo Anual 2015-2016 de la CC.NN UGKUM
}
\description{
Los datos analizados corresponden a un censo de un bosque de produccion de la Comunidad Nativa 
de nombre Ugkum, el cual viene solicitando permiso de aprovechamiento de cuatro especies de interes 
comercial. En este sentido el tema aborda un analisis estadistico descriptivo de la poblacion, 
determinacion del tamano optimo de la muestra y su utilidad para realizar una verificacion en campo. 
Tambien se realizara una analisis de correlacion y ajuste a fin de determinar una ecuacion de volumen 
en funcion al diametro de las especies.
}
\usage{data("ugkum")}
\format{
  A data frame with 395 observations on the following 10 variables.
  \describe{
    \item{\code{Arbol}}{a numeric vector}
    \item{\code{Codigo}}{a character vector}
    \item{\code{Especie}}{a character vector}
    \item{\code{Este}}{a numeric vector}
    \item{\code{Norte}}{a numeric vector}
    \item{\code{Dap}}{a numeric vector}
    \item{\code{AlturaComercial}}{a numeric vector}
    \item{\code{Volumen}}{a numeric vector}
    \item{\code{AreaBasal}}{a numeric vector}
    \item{\code{Observacion}}{a character vector}
  }
}
\details{
Arbol : Corresponde al numero de orden del arbol censado.
Codigo: Corresponde al codigo asignado a cada arbol, el mismo que es pintado en campo en el fuste del arbol.
Especie: Nombre comun o vernacular del arbol censado.
Dap: Diametro en metros a 1.30 mt de altura del suelo y esta en unidad de cm
Altura comercial: Altura en metros asumido a criterio del evaluador en funcion de la altura total y esta en unidades de metros
Area basal : Unidades de m2, que correponde al area de la circunferencia del fuste.
Este: Corresponde a las coordenada este UTM en el sistema de proyeccion global WGS84.
Norte: Corresponde a las coordenada norte UTM en el sistema de proyeccion global WGS84.

La importancia de los datos obedece que la comunidad nativa viene solicitando permiso de aprovechamiento 
de madera aserrada de cuatro especies de interes comercial, en tanto los datos deberan ser analizado 
tanto en gabiente y campo con ayuda del analisis estadistico y sus herramientas a fin de evaluar 
la viabilidad de la atencion de la solicitud del permiso de aprovechamiento de los voumenes solicitados 
por parte de la institucion encargada de otorgarlo.
}
\source{
Oficina de la Administracion Tecnica Forestal y de Fauna Silvestre Sede Condorcanqui Regio Amazonas, 
Comunidades Nativa UGKUM, mayo del 2015.
}
\references{
Cortesia: Consultor Forestal Ing.Forestal.Jose Rubio Latorre, alumno de la maestria de gestion de bosques. UNALM
}
\examples{
library(PBSmapping) # Funciones de coonversion de coordenadas
library(RgoogleMaps) # mapa de google
library(agroforestry)
data(ugkum)
A<-ugkum[,4:5]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= attributes(ugkum)$projection
attr(A, "zone")= attributes(ugkum)$zone
# Conversion coordenadas UTM a decimales.
B<-convUL(A,km=FALSE,southern=TRUE)  # informacion en metros
# Ubicacion geografica
lon<-mean(B[,1])
lat<-mean(B[,2])
center = c(lat, lon)
zoom <- 7
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=19,cex=0.4)
axis(1);axis(2)
}
\keyword{datasets}
