\name{sepahua}
\alias{sepahua}
\docType{data}
\title{
Inventario Forestal Sepahua Madre de Dios-Peru
}
\description{
Censo forestal de una empresa maderera del sector de Sepahua en la region de Madre de Dios
}
\usage{data("sepahua")}
\format{
  A data frame with 671 observations on the following 10 variables.
  \describe{
    \item{\code{N}}{a numeric vector}
    \item{\code{Especie}}{a character vector}
    \item{\code{Faja}}{a numeric vector}
    \item{\code{Codigo}}{a numeric vector}
    \item{\code{DAP}}{a numeric vector}
    \item{\code{AC}}{a numeric vector}
    \item{\code{Volumen}}{a numeric vector}
    \item{\code{Condicion}}{a character vector}
    \item{\code{Este}}{a numeric vector}
    \item{\code{Norte}}{a numeric vector}
  }
}
\details{
DAP: cm
altura: comercial en metros
volumen: metros cubicos
}
\source{
Empresa maderera del sector de Sepahua.
}
\references{
Cortesia: Jesus Alberto Flores, alumno de la maestria de gestion de bosques. UNALM
}
\examples{
library(PBSmapping) # Funciones de coonversion de coordenadas
library(RgoogleMaps) # mapa de google
library(agroforestry)
data(sepahua)
A<-sepahua[,9:10]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= attributes(sepahua)$projection
attr(A, "zone")= attributes(sepahua)$zone
# Conversion coordenadas UTM a decimales.
B<-convUL(A,km=FALSE,southern=TRUE)  # informacion en metros
# Ubicacion geografica
lon<-mean(B[,1])
lat<-mean(B[,2])
center = c(lat, lon)
zoom <- 14
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "satellite")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=19,cex=0.4)

}
\keyword{datasets}
