\name{schizolobium}
\alias{schizolobium}
\docType{data}
\title{ Especies reforestadas en la provincia de Satipo}
\description{
  Schizolubium parahiba (Pino chuncho) una de las especies estudiadas durante la 
  tesis: Contribucion al conocimiento silvicultural de las especies reforestadas
  en la provincia de Satipo. Los datos que se evaluaron en el campo fueron: Dap, 
  Altura comercial, estado fitosanitario y otros datos referentes al lugar de la 
  plantacion.
}
\usage{data(schizolobium)}
\format{
  A data frame with 100 observations on the following 4 variables.
  \describe{
    \item{\code{DAP}}{a numeric vector}
    \item{\code{HC}}{a numeric vector}
    \item{\code{AreaBasal}}{a numeric vector}
    \item{\code{volumen}}{a numeric vector}
  }
}
\details{
  Los datos corresponden a 100 arboles de la especie Schizolobium reforestados en
  la localidad de Sinchijaroque de la provincia de Satipo en selva central. Las plantaciones evaluadas fueron hechas por el comite de reforestacion
  Satipo-Chanchamayo. El lugar de ejecucion de este trabajo es la localidad de
  Sinchijaroque, provincia de Satipo en la selva central peruana. La especie Schizolobium es de variados usos en la industria de la artesania,
  en la construccion de cajoneria, en pequenos muebles, para elaboracion de palos
  de fosforo, etc.
  dap: es el diametro a la altura del pecho fue tomado a 1.30 m del ras del suelo en cada fuste. 
  HC: La altura comercial fue tomada utilizando un clinometro Sunto y corresponde a la longitud
  desde 0.20 cm del ras del suelo hasta donde empieza la ramificaciones (parte a aprovechar para madera.
  AB: El area basal para cada arbol fue calculado a partir de la medida del diametro (AB = PI*DAP2/4).
  VOLUMEN: La determinacion del volumen de cada arbol se hizo mediante la formula: V = AB*HC*FM.
  Siendo FM el factor morfico de la especie igual a 0.65.
}
\source{
  Localidad de Sinchijaroque de la provincia de Satipo en selva central.
}
\references{
  MANTURANO, D. 2007. Contribucion al conocimiento silvicultural de las especies
  forestales establecidas con fines de produccion de madera en la provincia de Satipo.
  Borrador de tesis para Magister Scientiae. EPG - UNALM, Lima, PE. 220 p.
  Cortesia: Adan Fernandez, alumno de la especialidad de Bosques. 2007
}
\examples{
  library(agroforestry)
  data(schizolobium)
  str(schizolobium)
}
\keyword{datasets}
