\name{saposoa}
\alias{saposoa}
\docType{data}
\title{
Parcela de corte anual(PCA-9), Saposoa
}
\description{
Plan operativo anual (POA-9) para concesiones Forestales  con Fines Maderables. Area total 981.507 ha. en
Bosques Humedo de Montana, ubicado en el departamento de San Martin, rio Huayabamba y Saposoa, 
en la cuenca quebrada Angashiyacu y Rio Saposoa. 
}
\usage{data("saposoa")}
\format{
  A data frame with 1515 observations on the following 12 variables.
  \describe{
    \item{\code{faja}}{a numeric vector}
    \item{\code{arbol}}{a numeric vector}
    \item{\code{especie}}{a character vector}
    \item{\code{dap}}{a numeric vector}
    \item{\code{altura}}{a numeric vector}
    \item{\code{distTrocha}}{a numeric vector}
    \item{\code{distArbol}}{a numeric vector}
    \item{\code{lado}}{a character vector}
    \item{\code{este}}{a numeric vector}
    \item{\code{norte}}{a numeric vector}
    \item{\code{volumen}}{a numeric vector}
    \item{\code{obs}}{a character vector}
  }
}
\details{
Arbol : Corresponde al numero de orden del arbol censado.
Codigo: Corresponde al codigo asignado a cada arbol, el mismo que es pintado en campo en el fuste del arbol.
Especie: Nombre comun o vernacular del arbol censado.
Dap: Diametro en metros a 1.30 mt de altura del suelo y esta en unidad de cm
Altura comercial: Altura en metros asumido a criterio del evaluador en funcion de la altura total y esta en unidades de metros
Area basal : Unidades de m2, que correponde al area de la circunferencia del fuste.
Este: Corresponde a las coordenada este UTM en el sistema de proyeccion global WGS84.
Norte: Corresponde a las coordenada norte UTM en el sistema de proyeccion global WGS84.

La importancia de los datos obedece que la comunidad nativa viene solicitando permiso de aprovechamiento 
de madera aserrada de cuatro especies de interes comercial, en tanto los datos deberan ser analizado 
tanto en gabiente y campo con ayuda del analisis estadistico y sus herramientas a fin de evaluar 
la viabilidad de la atencion de la solicitud del permiso de aprovechamiento de los voumenes solicitados 
por parte de la institucion encargada de otorgarlo.
}
\source{
Oficina de la Administracion Tecnica Forestal y de Fauna Silvestre Sede Condorcanqui Regio Amazonas, 
Comunidades Nativa UGKUM, mayo del 2015.
}
\references{
Cortesia: Consultor Forestal Ing.Forestal.Jose Rubio Latorre, alumno de la maestria de gestion de bosques. UNALM
}
\examples{
library(PBSmapping) # Funciones de conversion de coordenadas
library(RgoogleMaps) # mapa de google
library(agroforestry)
data(saposoa)
A<-saposoa[,9:10]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= attributes(saposoa)$projection
attr(A, "zone")= attributes(saposoa)$zone
# Conversion coordenadas UTM a decimales.
B<-convUL(A,km=FALSE,southern=TRUE)  # informacion en metros
# Ubicacion geografica
lon<-mean(B[,1])
lat<-mean(B[,2])
center = c(lat, lon)
zoom <- 7
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "roadmap")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=19,cex=0.4)
axis(1);axis(2)
}
\keyword{datasets}
