\name{pariamanu}
\alias{pariamanu}
\docType{data}
\title{
Inventario Forestal Pariamanu. Madre de Dios-Peru
}
\description{
Censo forestal de una empresa maderera del sector de Pariamanu en la region de Madre de Dios
}
\usage{data("pariamanu")}
\format{
  A data frame with 880 observations on the following 10 variables.
  \describe{
    \item{\code{faja}}{a numeric vector}
    \item{\code{codigo}}{a numeric vector}
    \item{\code{especie}}{a factor with levels \code{Ana caspi} \code{Azucar huayo} \code{Caoba} \code{Catahua} \code{Cedro} \code{Copaiba} \code{Cumala} \code{Estoraque} \code{Lagarto caspi} \code{Lupuna} \code{Misa } \code{Pashaco} \code{Pumaquiro} \code{Quillabordon} \code{Quinilla} \code{Shihuahuaco} \code{Tahuari} \code{Tornillo} \code{Yacushapana}}
    \item{\code{este}}{a numeric vector}
    \item{\code{norte}}{a numeric vector}
    \item{\code{dap}}{a numeric vector}
    \item{\code{altura}}{a numeric vector}
    \item{\code{volumen}}{a numeric vector}
    \item{\code{trozas}}{a numeric vector}
    \item{\code{fuste}}{a factor with levels \code{A} \code{B} \code{B } \code{C}}
  }
}
\details{
DAP: cm
altura: comercial en metros
volumen: metros cubicos
}
\source{
Empresa maderera del sector de Pariamanu.
}
\references{
Cortesia: Edith Ana Condori Yajahuanca, alumno de la maestria de gestion de bosques. UNALM
}
\examples{
library(PBSmapping) # Funciones de coonversion de coordenadas
library(RgoogleMaps) # mapa de google
library(agroforestry)
data(pariamanu)
str(pariamanu)
A<-pariamanu[,4:5]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= attributes(pariamanu)$projection
attr(A, "zone")= attributes(pariamanu)$zone
# Conversion coordenadas UTM a decimales.
B<-convUL(A,km=FALSE,southern=TRUE)  # informacion en metros
# Ubicacion geografica
lon<-mean(B[,1])
lat<-mean(B[,2])
center = c(lat, lon)
zoom <- 8
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "satellite")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=19,cex=0.4)

}
\keyword{datasets}
