\name{brunas}
\alias{brunas}
\docType{data}
\title{
  Inventario Brunas
}
\description{
Inventario forestal del Bosque Reservado De La Universidad Nacional Agraria De La Selva - BRUNAS.
Evaluacion hecha en una Parcela Permanente de medicion.
Importancia: Inventario de la Regeneracion Natural de un Bosque Residual de Colina Baja, toma de datos 
de la Categoria Silvicultural de Brinzal
  
}
\usage{data("brunas")}
\format{
  A data frame with 50 observations on the following 12 variables.
  \describe{
    \item{\code{x}}{a numeric vector}
    \item{\code{y}}{a numeric vector}
    \item{\code{categoria}}{a character vector}
    \item{\code{parcela}}{a numeric vector}
    \item{\code{subPar}}{a numeric vector}
    \item{\code{individuo}}{a numeric vector}
    \item{\code{especie}}{a character vector}
    \item{\code{cientifico}}{a character vector}
    \item{\code{familia}}{a character vector}
    \item{\code{altura}}{a numeric vector}
    \item{\code{diametro}}{a numeric vector}
    \item{\code{codigo}}{a character vector}
  }
}
\details{
Departamento de Huanuco, Provincia de Leoncio Prado, Distrito de Rupa Rupa. Evaluacion realizada 
en las instalaciones del Bosque Reservado De La Universidad Nacional Agraria De La Selva - BRUNAS.
Coordenadas geograficas de las PPMs (Datum WGS 84), vertice inicial.
  
- ESTE 391526.00\\
- NORTE 8969908.00\\
  
Objetivos del estudio
  
a)Evaluar los cambios en la estructura y dinamica en bosque residual de colinas.\\

b)Evaluar los cambios dasonomicos (diametro), de la categoria silvicultural de Brinzal.\\

}
\source{
  Facultad de Recursos Naturales Renovables - Area de Manejo Forestal
}
\references{
  Universidad nacional agraria de la selva.
}
\examples{
data(brunas)
library(PBSmapping) # Funciones de coonversion de coordenadas
library(RgoogleMaps) # mapa de google
A<-brunas[,1:2]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= "UTM"
attr(A, "zone")= 18
# Conversion coordenadas UTM a decimales.
B<-convUL(A,km=FALSE,southern=TRUE)  # informacion en metros
# Ubicacion geografica
lon<-mean(B[,1])
lat<-mean(B[,2])
center = c(lat, lon)
zoom <- 10
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "mapmaker-hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=15,cex=0.4)
text(0,0,"Brunas",col="yellow",cex=0.9)
#.....................
r1<-diff(range(puntos[,1]))
s1<-diff(range(brunas[,1]))
intervalo1<-100*s1/r1
media1<-mean(brunas[,1])
p1<-media1-3*intervalo1
#.....................
r2<-diff(range(puntos[,2]))
s2<-diff(range(brunas[,2]))
intervalo2<-100*s2/r2
media2<-mean(brunas[,2])
p2<-media2-3*intervalo2
#.....................
axis(1,seq(-300,300,100),round(seq(p1,by=intervalo1,length=7),0))
axis(2,seq(-300,300,100),round(seq(p2,by=intervalo2,length=7),0),las=2)
title("Inventario Brunas\nTingo Maria")
#----------------------------
zoom <- 20
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1,xlim=c(-170,170),ylim=c(-170,170))
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=14,cex=0.8)
axis(1);axis(2)
title("Dispersion de los arboles\nBrunas")
rect(-170,-170,170,170,border="red",lty=4,lwd=2)
points(170,170,cex=2,col="white")
points(-170,-170,cex=2,col="white")
points(-170,170,cex=2,col="white")
points(170,-170,cex=2,col="white")
#-------------------------------
par(mar=c(8,3,3,2))
tabla <- table(brunas$especie)
barplot(tabla,las=2,col=colors()[seq(2,by=3,length=11)], 
main="Distribucion de las especies de arboles en Brunas",cex.main=0.7)
#-------------------------------
par(mar=c(8,3,3,2))
HC<- subset(brunas,brunas$especie=="Huangana caspi")
A<-HC[,1:2]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= "UTM"
attr(A, "zone")= 18
B<-convUL(A,km=FALSE,southern=TRUE)  
zoom <- 20
MyMap <- GetMap(center=center, zoom=zoom, maptype = "hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1,xlim=c(-170,170),ylim=c(-170,170))
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=13,cex=0.8)
#.....................
r1<-diff(range(puntos[,1]))
s1<-diff(range(brunas[,1]))
intervalo1<-100*s1/r1
media1<-mean(brunas[,1])
p1<-media1-3*intervalo1
#.....................
r2<-diff(range(puntos[,2]))
s2<-diff(range(brunas[,2]))
intervalo2<-100*s2/r2
media2<-mean(brunas[,2])
p2<-media2-3*intervalo2
#.....................
axis(1,seq(-300,300,100),round(seq(p1,by=intervalo1,length=7),0))
axis(2,seq(-300,300,100),round(seq(p2,by=intervalo2,length=7),0),las=2)
title("Dispersion de Huangana caspi\nBrunas",cex.main=0.8)
borde <- chull(puntos)
borde <- c(borde,borde[1])
lines(puntos[borde,],col="white",lty=4,lwd=2)
#---------------------
###Estadisticas de altura y diametro por especie
by(brunas[,8:9],brunas$especie,function(x)summary(x))
par(mar=c(6,3,3,2),cex=0.8)
boxplot(altura ~ especie,data=brunas,col=colors()[seq(2,by=3,length=11)], main="Variacion de la altura por especie",las=2)
boxplot(diametro ~ especie,data=brunas,col=colors()[seq(2,by=3,length=11)], main="Variacion del diametro por especie",las=2)
}

\keyword{datasets}
