\name{bosques}
\alias{bosques}
\docType{data}
\title{ Inventario en Bosques Inundables del Centro de Investigacion Puerto Almendras}
\description{
  El inventario se realizo en el Centro de Investigacion y Ensenanza Forestal (CIEFOR)
  de puerto Almendra Iquitos-Peru, en un fragmento forestal tipico: Bosque Humedo Tropical,
  dentro de 4 ha aprox. (coordenadas 3g 49m 48s latitud sur y 73g 25m12s longitud Oeste)
  a una altitud promedio de 120 msnm.
}
\usage{data(bosques)}
\format{
  A data frame with 1897 observations on the following 16 variables.
  \describe{
    \item{\code{area}}{a numeric vector}
    \item{\code{faja}}{a numeric vector}
    \item{\code{distancia}}{a numeric vector}
    \item{\code{madera}}{a factor with levels \code{Aserrada} \code{Firewood and charcoal} \code{Otros} \code{Postes} \code{Redonda}}
    \item{\code{especie}}{a factor with levels \code{Achiotillo} \code{Apacharama} \code{Azucar huayo} \code{Azufre huayo} \code{Boa caspi} \code{Brea caspi} \code{Bubinsana} \code{Bushilla} \code{Cacahuillo} \code{Caimitillo} \code{Carahuasca} \code{Cascarilla} \code{Cetico} \code{Charichuelo} \code{Chimicua} \code{Chontaquiro} \code{Chullachaqui caspi} \code{Cinta caspi} \code{Copal} \code{Cumala} \code{Cumala blanca} \code{Cumala caupuri} \code{Espintana} \code{Guayabilla} \code{Huacapu} \code{Huacapurana} \code{Huacapurana macho} \code{Lagarto caspi} \code{Lanza huayo} \code{Machimango} \code{Machimango blanco} \code{Machimango colorado} \code{Mari mari} \code{Maria buena} \code{Moena} \code{Moena amarilla} \code{Mullaquillo} \code{Palometa huayo} \code{Pampa remo caspi} \code{Papelillo} \code{Parinari} \code{Pashaco} \code{Pashaco blanco} \code{Pashaco negro} \code{Pichirina} \code{Polvora caspi} \code{Punga} \code{Quillosisa} \code{Quinilla} \code{Raton caspi} \code{Remo caspi} \code{Renaco} \code{Requia} \code{Rifari} \code{Rifarillo} \code{Sacha guayaba} \code{Sacha huito} \code{Sacha parinari} \code{Sacha zapote} \code{Sapotillo} \code{Shimbillo} \code{Shiringa} \code{Shiringarana} \code{Shiringuilla} \code{Tamamuri} \code{Tangarana} \code{Violeta} \code{Yacushapana} \code{Zapotillo} \code{Zorro caspi}}
    \item{\code{DAP }}{a numeric vector}
    \item{\code{HC}}{a numeric vector}
    \item{\code{HT}}{a numeric vector}
    \item{\code{IC}}{a numeric vector}
    \item{\code{AreaBasal}}{a numeric vector}
    \item{\code{volumen}}{a numeric vector}
    \item{\code{ABHA}}{a numeric vector}
    \item{\code{VOLHA}}{a numeric vector}
    \item{\code{ABF}}{a numeric vector}
    \item{\code{VOLF}}{a numeric vector}
    \item{\code{material}}{a factor with levels \code{Joven} \code{JovenMediano} \code{Mediano} \code{Repoblado} \code{SobreMaduro}}
  }
}
\details{
   En el inventario se evaluaron las especies comercialmente valiosas encontrandose 
   1897 arboles en 4 fajas evaluadas determinandose el volumen por hectarea en cada
   faja y determinando el tamano minimo de muestra que se necesita asi como el error
   de muestreo este estudio es importante para determinar la abundancia de especies 
   que albergan en este tipo de ecosistema.
   DAP: Diametro a la Altura del Pecho.
   madera: Valor agregado de la madera.
   especie: Nombre Comun de la especie.
   HC: Altura Comercial.
   HT: Altura Total.
   IC: Iluminacion de copa.
   AreaBasal: Area Basal del arbol.
   volumen: Volumen del arbol.
   ABHA: Area Basal por Ha.
   VOLHA: Volumen por Ha.
   VOLF: Volumen por Faja.
   material: Estado silvicultural del arbol.
}
\source{
  Centro de Investigaci\'on y Ense\~nanza Forestal (CIEFOR) de puerto Almendra
  Iquitos-Peru. Bosque Humedo Tropical. Coordenadas 3g 49m 48s latitud sur y
  73g25m12s longitud Oeste) a una altitud promedio de 120 msnm.
}
\references{
  Campos Zumaeta, Luis E. (2004),Inventario Forestal en Bosques Inundables del 
  Centro de Investigacion y Ensenanza Puerto Almendras.Iquitos - Peru.
  Universidad Nacional de la Amazonia Peruana. Segunda Practica Pre-Profesional, 109 p.
}
\examples{
  library(agroforestry)
  data(bosques)
  str(bosques)
}
\keyword{datasets}
