\name{StaRosa}
\alias{StaRosa}
\docType{data}
\title{
Censo comercial del plan operativo anual 03 en la comunidad nativa Santa Rosa
}
\description{
Los datos que se utilizaran en el presente trabajo corresponden a un censo comercial del Plan Operativo Anual (POA 03), de la Comunidad Nativa Santa Rosa, ubicado en el distrito de Yurua, provincia de Atalaya, departamento de Ucayali, correspondiente a zafra 2009-2010, con un area de 766.61 hectareas
}
\usage{data("StaRosa")}
\format{
  A data frame with 1197 observations on the following 11 variables.
\describe{
    \item{\code{arbol}}{a numeric vector}
    \item{\code{faja}}{a numeric vector}
    \item{\code{especie}}{a factor with levels \code{aguanomasha} \code{azucar huayo} \code{cachimbo } \code{caoba } \code{capirona } \code{catahua} \code{cedro} \code{copaiba } \code{estoraque} \code{huayruro } \code{ishpingo} \code{lupuna} \code{mashonaste } \code{palisangre} \code{pumaquiro} \code{quillobordon } \code{quinilla} \code{shihuahuaco} \code{tahuari } \code{yacushapana }}
    \item{\code{dap}}{a numeric vector}
    \item{\code{altura}}{a numeric vector}
    \item{\code{volumen}}{a numeric vector}
    \item{\code{tipo}}{a factor with levels \code{A} \code{R} \code{S}}
    \item{\code{calidad}}{a numeric vector}
    \item{\code{este}}{a numeric vector}
    \item{\code{norte}}{a numeric vector}
    \item{\code{condicion}}{a character vector}
  }
}
\details{
faja: Indica el numero de faja, producto de la implementacion del censo comercial, el cual esta conformado por 74 fajas.
arbol: Indica el codigo del arbol distribuido en cada faja.
especie: Indica la especie identificada durante el censo comercial, el cual sera aprovechada.
DAP (cm): Indica el diametro a la altura del pecho de cada individuo, medido en unidades de centimetros.
Altura (m): Indica la altura comercial de cada individuo, medido en unidades de metros.
calidad: Calidad fuste, Indica la condicion fitosanitaria de los individuos (1=Bueno y 2= Regular)
este: Indica la ubicacion geografica medida en unidades de metros
norte: Indica la ubicacion geografica medida en unidades de metros
volumen (m3): Indica el volumen de cada individuo, medido en unidades de metros cubicos.
condicion: Indica la condicion de cada individuo descrito en el censo comercial, entre semillero o aprovechable.

Los datos presentados en la base de datos, son el producto de un censo comercial
del POA 03, correspondiente a la Comunidad Nativa Santa Rosa, los cuales han sido
levantados de un bosque natural. En ese sentido, dicha informacion permitira realizar
el aprovechamiento sostenible del recurso forestal maderable, bajo los criterios
que conlleva el manejo forestal, que a su vez permitira el aprovechamiento con
impacto reducido y con una debida planificacion, teniendo una idea de su potencial
maderable y de la distribucion espacial, y por consecuencia se asegure el material
genetico de las especies a extraer, a traves de los individuos semilleros, encargados
de proporcionar semillas para su propagacion.
}
\source{
Comunidad Nativa Santa Rosa
}
\references{
Estos datos fueron brindados por el Organismo de Supervision de los Recursos Forestales
y de Fauna Silvestre (OSINFOR).
}
\examples{
data(StaRosa)
## maybe str(StaRosa) ; plot(StaRosa) ...
}
\keyword{datasets}
