\name{Otorongo}
\alias{Otorongo}
\docType{data}
\title{Censo comercial del plan operativo anual 07 del consolidado forestal  OTORONGO S.A.C.
}
\description{
Censo comercial del Plan Operativo Anual nro 07 de la Empresa Forestal Consolidado Otorongo S.A.C., 
que viene a ser un consolidado de 5 concesiones (empresa Forestal Portillo S.R.L., 
empresa Forestal Otorongo S.A.C. Sector "A", empresa Forestal Otorongo SAC. Sector "B", 
Forestal Rio Piedras S.A.C. y Forestal Monago), sobre una superficie de 75,333.0 hectareas, 
en el distrito de Iberia, provincia de Tahuamanu y departamento de Madre de Dios, ubicado en el 
distrito de Yurua, provincia de Atalaya, departamento de Ucayali, correspondiente a zafra 2009-2010, 
con un area de 4,800.00 hectareas.
}
\usage{data("Otorongo")}
\format{
  A data frame with 4089 observations on the following 8 variables.
  \describe{
    \item{\code{FC}}{clase}
    \item{\code{Block}}{12 bloques}
    \item{\code{Line}}{21 lineas o fajas}
    \item{\code{tree}}{Numero del arbol}
    \item{\code{specie}}{12 especies identificadas}
    \item{\code{DAP}}{Diametro a la altura del pecho}
    \item{\code{height}}{Altura comercial del arbol}
    \item{\code{volume}}{Volumen de madera comercial aprovechable expresados en metros cubicos}
  }
}
\details{
  Los datos conformados en la base de datos, son el producto de un censo comercial del POA 07, 
  correspondiente a la Empresa Forestal Consolidado Otorongo S.A.C., los cuales han sido levantados 
  de un bosque natural. En ese sentido, dicha informacion permitira realizar el aprovechamiento 
  sostenible del recurso forestal maderable, bajo los criterios que conlleva el manejo forestal, 
  que a su vez permitira el aprovechamiento con impacto reducido y con una debida planificacion, 
  teniendo una idea de su potencial maderable y de la distribucion espacial, y por consecuencia 
  se asegure el material genetico de las especies a extraer, a traves de los individuos semilleros, 
  encargados de proporcionar semillas para su propagacion.
}
\source{
  Informacion recogida por el Organismo de Evaluacion de los Recursos Forestales y de Fauna Silvestre.
}
\references{
  Cortesia Alumno de Post Grado de Gention de Bosques: Jorge Vasquez Penaherrera
}
\examples{
  library(agricolae)
  data(Otorongo)
  levels(Otorongo$specie)
  table(Otorongo$specie)
  caoba<-subset(Otorongo,Otorongo$specie=="Caoba")
  cedro<-subset(Otorongo,Otorongo$specie=="Cedro")
  ishpingo<-subset(Otorongo,Otorongo$specie=="Ishpingo")
  #caoba
  correlation(caoba[,6:7])
  with(caoba,plot(DAP,volume,pch=20,col=2,main="Caoba",xlab="dap",ylab="Volumen",cex=2))
  modelo<-lm(volume ~ DAP, data=caoba)
  abline(modelo)
  grid(col="red")
}
\keyword{datasets}
