\name{LoretoYacu}
\alias{LoretoYacu}
\docType{data}
\title{
  Inventario Forestal en CCNN Santa Rosa de Loretoyacu
}
\description{
  El presente Inventario forestal del Centro Comunal Santa Rosa de Loretoyacu realizo una evaluacion 
  en una parcela permanente de medicion. El Inventario proporciona informacion de la distribucion de 
  las especies de arboles, ubicacion de la especie mas abundante, asi como las estadisticas de las 
  variables diametro y altura y su variacion por especie.
}
\usage{data("LoretoYacu")}
\format{
  A data frame with 235 observations on the following 9 variables.
  \describe{
    \item{\code{X}}{a numeric vector}
    \item{\code{Y}}{a numeric vector}
    \item{\code{Especie}}{a character vector}
    \item{\code{Ncomun}}{a character vector}
    \item{\code{Faja}}{a numeric vector}
    \item{\code{Codigo}}{a numeric vector}
    \item{\code{Diametro}}{a numeric vector}
    \item{\code{Altura}}{a numeric vector}
    \item{\code{volumen}}{a numeric vector}
  }
}
\details{
  Objetivo: La finalidad del Inventario forestal es evaluar los recursos forestales 
  en una parcela de medicion.
  Los datos del inventario de arboles se recogen exclusivamente dentro de los limites del area 
  de muestreo. Las Coordenadas geograficas UTM, Zone=19.
  Dentro de cada parcela se delimitan subparcelas rectangulares de 20 m. x 10 m., 
  situadas en el centro de las subparcelas rectangulares. Ambas categorias. 
  Las subparcelas sirven para medir el diametro de arboles (Dap < 1.30)
  
Ubicacion geografica\\
a)	Departamento Loreto\\
b)	Provincia Mariscal Ramon Castilla\\
c)	Centro comunal Santa Rosa de Loretoyacu\\

Ubicacion de los arboles.
Zona de Vida: bmh - PT/bh - T (Bosque muy humedo - Premontano Tropical a bosque humedo - Tropical)
Se considero el sistema de clasificacion del Dr. Holdridge, identificandose una sola zona zonas de vida, 
la cual se encuentra en el denominado Llano Amazonico que va hasta los 320 m.s.n.m.
La Zona de Vida se distribuye en la region latitudinal Tropical del pais. 
Se emplaza ocupando geoformas de colinas bajas ligera a fuertemente inclinadas, lomas, 
terrazas aluviales antiguas de moderada disecacion, con una flora heterogenea, alta y 
densa latifoliada de tierra firme (no inundable). En el bosque muy humedo Premontano Tropical (bmh - PT), 
la biotemperatura media anual maxima es de 25.6 grados centigrado y la media anual minima de 18.5 grados centigrados, 
Sus precipitaciones medias anuales pueden sobrepasar los 3,000 mm media anual.
La especie Virola sp. es la de mayor importancia forestal.
}

\references{
cortesia: Jeimi Katherin Rimayhuaman Candela, alumno de la maestria de Gestion de Bosques  
}
\examples{
data(LoretoYacu)
# Descripcion del area de muestreo
# Los datos del inventario de arboles se recogen exclusivamente dentro de los limites del area de 
# muestreo. Las Coordenadas geograficas UTM, Zone=19.
# Dentro de cada parcela se delimitan subparcelas rectangulares de 20 m. x 10 m., 
# situadas en el centro de las subparcelas rectangulares. Ambas categorias. 
# Las subparcelas sirven para medir el diametro de arboles (Dap < 1.30)
santarosa<-LoretoYacu
library(PBSmapping) # Funciones de coonversion de coordenadas
library(RgoogleMaps) # mapa de google
A<-santarosa[,1:2]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= "UTM"
attr(A, "zone")= 18
# Conversion coordenadas UTM a decimales.
B<-convUL(A,km=FALSE,southern=TRUE)  # informacion en metros
# Ubicacion geografica
lon<-mean(B[,1])
lat<-mean(B[,2])
center = c(lat, lon)
zoom <- 9
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "mapmaker-hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=15,cex=0.4)
text(0,0,"santarosa",col="yellow",cex=0.9)
#.....................
r1<-diff(range(puntos[,1]))
s1<-diff(range(santarosa[,1]))
intervalo1<-100*s1/r1
media1<-mean(santarosa[,1])
p1<-media1-3*intervalo1
#.....................
r2<-diff(range(puntos[,2]))
s2<-diff(range(santarosa[,2]))
intervalo2<-100*s2/r2
media2<-mean(santarosa[,2])
p2<-media2-3*intervalo2
#.....................
axis(1,seq(-300,300,100),round(seq(p1,by=intervalo1,length=7),0))
axis(2,seq(-300,300,100),round(seq(p2,by=intervalo2,length=7),0),las=2)
title("Inventario Forestal CCNN Santa Rosa\nLoreto")

### Ubicacion de los arboles.

zoom <- 15
# maptype = c("roadmap", "mobile", "satellite", "terrain","hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1,xlim=c(-100,100),ylim=c(-100,100))
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=14,cex=0.8)
axis(1);axis(2)
title("Dispersion de arboles CCNN Santa Rosa de Loretoyacu\nLoreto")
borde <- chull(puntos)
borde <- c(borde,borde[1])
lines(puntos[borde,],col="white",lty=4,lwd=2)

###Distribucion de las especies de arboles forestales 

par(mar=c(8,3,3,2))
tabla <- table(santarosa$Especie)
barplot(tabla,las=2,col=colors()[seq(2,by=3,length=11)],main="Distribucion de las especies forestales en CCNN Santa Rosa de Loretoyacu",cex.main=1)
  
###Ubicacion de las especie Virola sp en Santa Rosa
par(mar=c(8,3,3,2))
virola<- subset(santarosa,santarosa$Especie=="Virola sp.")
A<-virola[,1:2]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= "UTM"
attr(A, "zone")= 18
B<-convUL(A,km=FALSE,southern=TRUE)  
zoom <- 15
MyMap <- GetMap(center=center, zoom=zoom, maptype = "hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1,xlim=c(-100,100),ylim=c(-100,100))
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=13,cex=0.8)
#.....................
r1<-diff(range(puntos[,1]))
s1<-diff(range(virola[,1]))
intervalo1<-100*s1/r1
media1<-mean(virola[,1])
p1<-media1-3*intervalo1
#.....................
r2<-diff(range(puntos[,2]))
s2<-diff(range(virola[,2]))
intervalo2<-100*s2/r2
media2<-mean(virola[,2])
p2<-media2-3*intervalo2
#.....................
axis(1,seq(-300,300,100),round(seq(p1,by=intervalo1,length=7),0))
axis(2,seq(-300,300,100),round(seq(p2,by=intervalo2,length=7),0),las=2)
title("Dispersion de Virola sp. en CCNN Santa Rosa de Loretoyacu\nLoreto",cex.main=0.8)
borde <- chull(puntos)
borde <- c(borde,borde[1])
lines(puntos[borde,],col="white",lty=4,lwd=2)
  
##Estadisticas de Diametro y altura por especie
by(santarosa[,5:6],santarosa$Especie,function(x)summary(x))
 
###Comparacion de altura y variacion por especie

par(mar=c(3,12,3,1),cex=0.8)
boxplot(Altura ~ Especie,data=santarosa,col=colors()[seq(2,by=3,length=11)], 
main="Variacion de la altura por especie",las=2,horizontal=TRUE)
boxplot(Diametro ~ Especie,data=santarosa,col=colors()[seq(2,by=3,length=11)], 
main="Variacion del diametro por especie",las=2,horizontal=TRUE)
}
\keyword{datasets}
