\name{LanchaPoza}
\alias{LanchaPoza}
\docType{data}
\title{
  Inventario Lancha Poza
}
\description{
  El inventario forestal corresponde al ano operativo Nro. 08, de la Comunidad Nativa Lancha Poza, 
  titular del Derecho de Aprovechamiento para extraccion forestal. El inventario forestal se realizo 
  considerando las especies comerciales de interes comercial en el area a intervenir, de la Parcela 
  de Corta Anual VIII, ubicado en el sector de la quebrada fandela, afluente al rio Napo, 
  distrito de Napo, provincia de Maynas, departamento de Loreto.
}
\usage{data("LanchaPoza")}
\format{
  A data frame with 1124 observations on the following 10 variables.
  \describe{
    \item{\code{Faja}}{a character vector}
    \item{\code{COD._Arbol}}{a numeric vector}
    \item{\code{Especie}}{a character vector}
    \item{\code{DAP}}{a numeric vector}
    \item{\code{Altura}}{a numeric vector}
    \item{\code{Calidad.Fuste}}{a character vector}
    \item{\code{Este}}{a numeric vector}
    \item{\code{Norte}}{a numeric vector}
    \item{\code{Vc}}{a numeric vector}
    \item{\code{Area.Basal}}{a numeric vector}
  }
}
\references{
  Cortesia: Alumno de la mestria de Gestion de Bosques: Fredy Palas, 2015
}
\examples{
data(LanchaPoza)
# Descripcion del sitio y ubicacion geografica.
# Coordenadas geograficas
# UTM, Zone=18
library(PBSmapping) # Funciones de coonversion de coordenadas
library(RgoogleMaps) # mapa de google
A<-LanchaPoza[,7:8]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= "UTM"
attr(A, "zone")= 18
# Conversion coordenadas UTM a decimales.
B<-convUL(A,km=FALSE,southern=TRUE)  # informacion en metros
# Ubicacion geografica
lon<-mean(B[,1])
lat<-mean(B[,2])
center = c(lat, lon)
zoom <- 15
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "mapmaker-hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=15,cex=0.4)
text(0,0,"lancha",col="yellow",cex=0.9)
#.....................
r1<-diff(range(puntos[,1]))
s1<-diff(range(LanchaPoza[,7]))
intervalo1<-100*s1/r1
media1<-mean(LanchaPoza[,7])
p1<-media1-3*intervalo1
#.....................
r2<-diff(range(puntos[,2]))
s2<-diff(range(LanchaPoza[,8]))
intervalo2<-100*s2/r2
media2<-mean(LanchaPoza[,8])
p2<-media2-3*intervalo2
#.....................
axis(1,seq(-300,300,100),round(seq(p1,by=intervalo1,length=7),0))
axis(2,seq(-300,300,100),round(seq(p2,by=intervalo2,length=7),0),las=2)
title("Inventario Lancha\nNapo")

## Ubicacion de los arboles.

## Describir la geografica, zona de vida, cultivo y paisaje de la zona

zoom <- 14
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1,xlim=c(-200,100),ylim=c(-200,100))
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=10,cex=0.8)
axis(1);axis(2)
title("Dispersion de los arboles\nlancha")
borde <- chull(puntos)
borde <- c(borde,borde[1])
lines(puntos[borde,],col="white",lty=4,lwd=2)

###Distribucion de las especies de arboles en Lancha Poza

par(mar=c(8,3,3,2))
tabla <- table(LanchaPoza$Especie)
barplot(tabla,las=2,col=colors()[seq(2,by=3,length=11)],main="Distribucion de las especies de arboles en lancha",cex.main=0.7)

###Ubicacion de las especie Cedro en Lancha Poza

par(mar=c(8,3,3,2))
HC<- subset(LanchaPoza,LanchaPoza$Especie=="CEDRO")
A<-HC[,7:8]
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= "UTM"
attr(A, "zone")= 18
B<-convUL(A,km=FALSE,southern=TRUE)  
zoom <- 14
MyMap <- GetMap(center=center, zoom=zoom, maptype = "hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1,xlim=c(-170,170),ylim=c(-170,170))
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=13,cex=0.8)
borde <- chull(puntos)
borde <- c(borde,borde[1])
lines(puntos[borde,],col="white",lty=4,lwd=2)
#.....................
r1<-diff(range(puntos[,1]))
s1<-diff(range(LanchaPoza[,7]))
intervalo1<-100*s1/r1
media1<-mean(LanchaPoza[,7])
p1<-media1-3*intervalo1
#.....................
r2<-diff(range(puntos[,2]))
s2<-diff(range(LanchaPoza[,8]))
intervalo2<-100*s2/r2
media2<-mean(LanchaPoza[,8])
p2<-media2-3*intervalo2
#.....................
axis(1,seq(-300,300,100),round(seq(p1,by=intervalo1,length=7),0))
axis(2,seq(-300,300,100),round(seq(p2,by=intervalo2,length=7),0),las=2)
title("Dispersion de CEDRO\nlancha",cex.main=0.8)

###Estadisticas de altura y diametro por especie

by(LanchaPoza[,7:8],LanchaPoza$Especie,function(x)summary(x))

###Comparacion de altura y variacion por especie

par(mar=c(6,3,3,2),cex=0.8)
boxplot(Altura ~ Especie,data=LanchaPoza,col=colors()[seq(2,by=3,length=11)], main="Variacion de la altura por especie",las=2)
boxplot(DAP ~ Especie,data=LanchaPoza,col=colors()[seq(2,by=3,length=11)], main="Variacion del diametro por especie",las=2)
}  
\keyword{datasets}
