\name{Isabelita}
\alias{Isabelita}
\docType{data}
\title{
  Inventario Isabelita POA 2
}
\description{
  Censo comercial del Plan Operativo Anual 02 - PCA 07 de la Empresa Maderera Indusrial Isabelita SAC. 
  Tiene una superficie de 2 200.57 hectarea.
}
\usage{data("Isabelita")}
\format{
  A data frame with 5441 observations on the following 12 variables.
  \describe{
    \item{\code{este}}{a numeric vector}
    \item{\code{norte}}{a numeric vector}
    \item{\code{N}}{a numeric vector}
    \item{\code{bloque}}{I y II}
    \item{\code{faja}}{a numeric vector}
    \item{\code{estrada}}{a numeric vector}
    \item{\code{codigo}}{a character vector}
    \item{\code{especie}}{21 especies}
    \item{\code{dap}}{Diametro a la altura del pecho (cm)}
    \item{\code{altura}}{comercial del arbol (m)}
    \item{\code{calidad}}{a numeric vector}
    \item{\code{Situacion}}{a character vector}
  }
}
\details{
  Volumen (m3): 0.7854*dap*dap*altura*0.65
  Distrito: Inapari
  Provincia: Tahuamanu 
  Departamento :Madre de Dios
  Este = 405476
  norte= 8762244
  Zona = 19
  
}
\source{
  Empresa Forestal Consolidado Otorongo S.A.C.
  Censo comercial: Plan Operativo Anual nro 02
}
\examples{
data(Isabelita)
library(PBSmapping) # Funciones de coonversion de coordenadas
library(RgoogleMaps) # mapa de google
A<-Isabelita[,1:2]
A<-na.omit(A)
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= "UTM"
attr(A, "zone")= 19
# Conversion coordenadas UTM a decimales.
B<-convUL(A,km=FALSE,southern=TRUE)  # informacion en metros
# Ubicacion geografica
lon<-mean(B[,1])
lat<-mean(B[,2])
center = c(lat, lon)
zoom <- 8
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "roadmap")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=19,cex=0.4)
axis(1);axis(2)
text(0,-20,"ISABELITA",col="blue",cex=0.7)
MyMap <- GetMap(center=center, zoom=10, maptype = "hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom=10)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=19,cex=0.4)
text(0,-20,"ISABELITA",col="blue",cex=0.7)

### Posicion de los arboles en la localidad

MyMap <- GetMap(center=center, zoom=13, maptype = "satellite")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom=13)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="yellow",pch=19,cex=0.4)
text(0,-20,"ISABELITA",col="blue",cex=0.7)

##Distribucion de especies
#La parcela de corta anual, tiene en toda su exxtension 21 especies forestales, 
#entre las mas diversas estan la Pona, Shihuahuaco, Estoraque.

par(mar=c(10,3,3,1),cex=0.8)
tabla<-table(Isabelita[,6])
barplot(tabla,las=2,col=colors()[2:21])

###Ubicacion de la especie ANACASPI

anacaspi<-Isabelita[Isabelita[,8]=="ANACASPI",]
anacaspi<-anacaspi[-234,]
A<-anacaspi[,1:2]
A<-na.omit(A)
names(A)<-c("X","Y")
A<-as.matrix(A)
attr(A, "projection")= "UTM"
attr(A, "zone")= 19
# Conversion coordenadas UTM a decimales.
B<-convUL(A,km=FALSE,southern=TRUE)  # informacion en metros
# Ubicacion geografica
lon<-mean(B[,1])
lat<-mean(B[,2])
center = c(lat, lon)
zoom <- 13
# maptype = c("roadmap", "mobile", "satellite", "terrain",
#            "hybrid", "mapmaker-roadmap", "mapmaker-hybrid")
#zoom grado de alejamiento o acercamiento 1:mapa global, 9:mas cerca
MyMap <- GetMap(center=center, zoom=zoom, maptype = "hybrid")
PlotOnStaticMap(MyMap, mar=c(3,5,3,1),cex.axis=0.8,las=1)
title(main="ISABELITA\nEspecie Anacaspi")
LatLon<-LatLon2XY.centered(MyMap, B[,2],B[,1],zoom)
puntos<-cbind(LatLon[[1]],LatLon[[2]])
points(puntos, col="white",pch=14,cex=0.6)
axis(1);axis(2)
borde <- chull(puntos)
borde <- c(borde,borde[1])
lines(puntos[borde,],col="yellow",lty=2,lwd=2)

###Estadisticas de diametro y altura por especie
  
by(Isabelita[,9:10],Isabelita$especie, summary)

}
\keyword{datasets}
